/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.Utility;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.config.StringListConfig;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.OnEntitySignalCheck;
import com.mlib.contexts.OnEntitySignalReceived;
import com.mlib.contexts.OnLoot;
import com.mlib.contexts.OnPlayerTick;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.effects.SoundHandler;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.entities.EntityHelper;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.api.distmarker.Dist;

public class SixthSenseEnchantment
extends CustomEnchantment {
    public SixthSenseEnchantment() {
        this.rarity(Enchantment.Rarity.VERY_RARE).category(EnchantmentCategory.ARMOR_HEAD).slots(EquipmentSlots.HEAD).minLevelCost(level -> 15).maxLevelCost(level -> 45);
    }

    public boolean m_6594_() {
        return false;
    }

    public boolean m_6081_(ItemStack itemStack) {
        return this.f_44672_.m_7454_(itemStack.m_41720_());
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemStack) {
        return false;
    }

    public boolean m_6591_() {
        return true;
    }

    @AutoInstance
    public static class Handler {
        static final ResourceLocation LOOT_ID = Registries.getLocation("chests/ancient_city_sixth_sense");
        final DoubleConfig glowDuration = new DoubleConfig(2.0, new Range((Number)0.5, (Number)15.0));
        final Supplier<SixthSenseEnchantment> enchantment = Registries.SIXTH_SENSE;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.ENCHANTMENT).name("SixthSense").comment("Highlights nearby mobs that emit any sound if the player is sneaking nearby.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnEntitySignalCheck.listen((Consumer)OnEntitySignalCheck.DISPATCH).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.player)).addCondition(Condition.isShiftKeyDown(data -> data.player)).addCondition(Condition.isOnGround(data -> data.player)).insertTo(group);
            OnEntitySignalReceived.listen(this::highlightEntity).addCondition(Condition.predicate(data -> data.player instanceof ServerPlayer)).addCondition(Condition.predicate(data -> data.owner != null && data.owner != data.player)).addConfig((IConfigurable)this.glowDuration.name("glow_duration").comment("Determines how long the mob should be highlighted (this value stacks up with every sound emitted).")).insertTo(group);
            OnPlayerTick.listen(this::playSound).addCondition(Condition.isServer()).addCondition(Condition.cooldown((int)Utility.secondsToTicks((double)1.25), (Dist)Dist.DEDICATED_SERVER).configurable(false)).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.player)).addCondition(Condition.isShiftKeyDown(data -> data.player)).addCondition(Condition.isOnGround(data -> data.player)).insertTo(group);
            OnLoot.listen(this::addToChest).addCondition(Condition.isServer()).addCondition(Handler.isAncientCityChest()).addCondition(OnLoot.hasOrigin()).insertTo(group);
        }

        private void highlightEntity(OnEntitySignalReceived.Data data) {
            EntityHelper.sendExtraClientGlowTicks((ServerPlayer)((ServerPlayer)data.player), (Entity)data.owner, (int)this.glowDuration.asTicks());
        }

        private void playSound(OnPlayerTick.Data data) {
            SoundHandler.HEARTBEAT.play(data.getLevel(), data.player.m_20182_(), SoundHandler.randomized((float)0.3f));
        }

        private void addToChest(OnLoot.Data data) {
            data.addAsChestLoot(LOOT_ID);
        }

        private static Condition<OnLoot.Data> isAncientCityChest() {
            Condition condition = OnLoot.is((ResourceLocation[])new ResourceLocation[]{BuiltInLootTables.f_230876_, BuiltInLootTables.f_230877_});
            Object e = condition.getConfigs().get(0);
            if (e instanceof StringListConfig) {
                StringListConfig config = (StringListConfig)e;
                config.comment("Determines which chests should contain this enchantment.");
            }
            return condition;
        }
    }
}

